package gov.va.vinci.dart.json.builder;

import java.util.ArrayList;
import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import com.ibm.icu.text.SimpleDateFormat;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.json.EventRequestView;
import gov.va.vinci.dart.json.EventView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestEventRequestViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		EventRequestViewBuilder builder = new EventRequestViewBuilder();
		
		try {
			builder.build((Request)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		Request request = DartObjectFactory.getInstance().getRequestDAO().findById(1);
		
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");

		EventRequestView erv = builder.build(request);
		
		Assert.assertNotNull(erv);
		Assert.assertEquals(erv.getRequestId(), 1);
		Assert.assertEquals(erv.getTrackingNumber(), request.getTrackingNumber());
		Assert.assertEquals(erv.isAmendment(), request.isAmendment());
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), request.getEvents().size());
		
		// if there happens to be an event in there, test against it
		if (request.getEvents().size() > 0) {
			Event testEvent = request.getEvents().get(0);
			boolean foundit = false;
			
			for (EventView ev : erv.getEvents()) {
				if (testEvent.getDescription().equals(ev.getDescription())) {
					// found the matching event
					
					Assert.assertEquals(testEvent.getCreatedBy(), ev.getPerson());
					//Assert.assertEquals(ev.getDateTime(), sdf.format(testEvent.getCreatedOn()));
					foundit = true;
					break;
				}
			}
			
			Assert.assertTrue(foundit);
		}
	}
	
	@Test
	public void testTwo() throws Exception {
		EventRequestViewBuilder builder = new EventRequestViewBuilder();
		
		// List<EventSummary> eventSummaryList
		try {
			builder.build((List<EventSummary>)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		List<EventSummary> esList = new ArrayList<EventSummary>();
		
		EventRequestView erv = builder.build(esList);
		Assert.assertNotNull(erv);
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 0);

		java.sql.Timestamp now = new java.sql.Timestamp(System.currentTimeMillis());
		
		EventSummary summary = new EventSummary();
		summary.setRequestId(2);
		summary.setRequestTrackingNumber("tracking number");
		summary.setAmendment(true);
		summary.setDescription("description");
		summary.setCreatedBy("DNS");
		summary.setCreatedOn(now);
		esList.add(summary);

		erv = builder.build(esList);
		Assert.assertNotNull(erv);
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 1);
		Assert.assertEquals(erv.getRequestId(), 2);
		Assert.assertEquals(erv.getTrackingNumber(), "tracking number");
		Assert.assertTrue(erv.isAmendment());

		EventView ev = erv.getEvents().get(0);
		
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");

		Assert.assertNotNull(ev);
		Assert.assertEquals(ev.getDescription(), "description");
		//Assert.assertEquals(ev.getDateTime(), sdf.format(now));
		Assert.assertEquals(ev.getPerson(), "DNS");

	}
	
	@Test
	public void testThree() throws Exception {
		EventRequestViewBuilder builder = new EventRequestViewBuilder();
		
		// List<EventSummary> eventSummaryList
		try {
			builder.build((List<EventSummary>)null, 1);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		List<EventSummary> esList = new ArrayList<EventSummary>();
		
		EventRequestView erv = builder.build(esList, 1);
		Assert.assertNotNull(erv);
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 0);

		java.sql.Timestamp now = new java.sql.Timestamp(System.currentTimeMillis());
		
		EventSummary summary = new EventSummary();
		summary.setRequestId(2);
		summary.setRequestTrackingNumber("tracking number");
		summary.setAmendment(true);
		summary.setDescription("description");
		summary.setCreatedBy("DNS");
		summary.setCreatedOn(now);
		esList.add(summary);

		erv = builder.build(esList, 1);  // wrong request id
		Assert.assertNotNull(erv);
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 0);

		erv = builder.build(esList, 2);
		Assert.assertNotNull(erv);
		Assert.assertNotNull(erv.getEvents());
		Assert.assertEquals(erv.getEvents().size(), 1);
		Assert.assertEquals(erv.getRequestId(), 2);
		Assert.assertEquals(erv.getTrackingNumber(), "tracking number");
		Assert.assertTrue(erv.isAmendment());

		EventView ev = erv.getEvents().get(0);
		
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");

		Assert.assertNotNull(ev);
		Assert.assertEquals(ev.getDescription(), "description");
		//Assert.assertEquals(ev.getDateTime(), sdf.format(now));
		Assert.assertEquals(ev.getPerson(), "DNS");

	}
}
